<?php

namespace App\Addresses;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Country extends Model 
{

    protected $table = 'countries';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('is_default', 'is_enabled', 'code', 'logo', 'image');

    public function translations()
    {
        return $this->hasMany('App\Addresses\CountryTranslation');
    }

}